if ($ARGV[0] eq "-h") { print "Index maker for MapleVr4\n ";
print "This perl script produces a MapleVr4 worksheet which contains\n";
print "a sorted list of all bookmarks in a collection of worksheets.\n";
print "These bookmarks are linked to the appropriate worksheet, thus\n";
print "giving an active index.  Also, the index worksheet contains a\n";
print "link to a 'table of contents' worksheet.  This enables one to\n";
print "construct a 'book' of worksheets with a table of contents and\n";
print "an index.\n\n";
print "Usage:  perl windex.pl index\_name toc\_name file\_of\_wkshts\n";
print "where   windex.pl is the name of this perl script.\n";
print "        index\_name is index worksheet produced (eg index.mws)\n";
print "        toc\_name is the table of contents wkshts (eg toc.mws)\n";
print "        file\_of\wkshts is the file containing the names of the\n";
print "        worksheets in the 'book'.\n";
print "Written, but not guaranteed, by Carl Eberhart, Math Dept, U.Ky.\n";
print "                                carl\@ms.uky.edu\n";
exit;}

$index = shift @ARGV;
open(INDEX,">$index");
$toc = shift @ARGV;
print INDEX "\{VERSION 2 3 \"IBM INTEL NT\" \"2.3\" \}\n";
print INDEX "\{USTYLETAB \{CSTYLE \"Maple Input\" -1 0 \"Courier\" 0 1 255 0 0 1 0 1 0 0 \n";
print INDEX "1 0 0 0 0 \}\{CSTYLE \"Hyperlink\" -1 17 \"\" 0 1 0 128 128 1 0 0 1 0 0 0 0 \n";
print INDEX "0 0 \}\{CSTYLE \"\" -1 257 \"\" 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 \}\{PSTYLE \"Norm\n";
print INDEX "al\" -1 0 1 \{CSTYLE \"\" -1 -1 \"\" 0 1 114 32 105 0 0 0 0 0 0 0 0 0 0 \}0 \n";
print INDEX "0 0 -1 -1 -1 0 0 0 0 0 0 -1 0 \}\{PSTYLE \"Heading 1\" 0 3 1 \{CSTYLE \"\" \n";
print INDEX "-1 -1 \"\" 1 18 0 0 0 0 0 1 0 0 0 0 0 0 0 \}1 0 0 0 6 6 0 0 0 0 0 0 -1 0 \n";
print INDEX "\}\{PSTYLE \"\" 3 256 1 \{CSTYLE \"\" -1 -1 \"\" 0 1 44 0 96 0 0 0 0 0 0 0 0 0 \n";
print INDEX "0 \}3 0 0 -1 -1 -1 0 0 0 0 0 0 -1 0 \}\}\n";
print INDEX "\{SECT 0 \{SECT 0 \{PARA \n";
print INDEX "256 \"\" 0 \"\" \{TEXT -1 6 \" Index\" \}\}\}\{EXCHG \{PARA 0 \"\" 0 \"\" \{HYPERLNK \n";
print INDEX "17 \"Table of contents\" 1 \"$toc\" \"\" \}\{TEXT 257 0 \"\" \}\}\}\n";
#$* = 1; 
$/ = "";
$first = "\{EXCHG \{PARA 0 \"\" 0 \"\" \{HYPERLNK 17 ";
$mid = "\}\{TEXT -1 ";
$last = "\" \}\}\}"; 
$i = 0;
open(LISTOFILES,$ARGV[0]);
@files=split(/[ \n]/,<LISTOFILES>);
FILENAME:
for $file (@files){
next FILENAME unless -T $file;
if (!open(FILE,$file)) {print  "Can't open $file - continuing... \n";
next FILENAME;}

while ( <FILE>) {if (@matches=/\"([\w\=\`\~\|\_\<\>\'\.\,\^\&\*\?\!\@\#\%\\\+\;\(\)\:\]\[\}\{\.\s]+)\" \{M?P?L?TEXT /g) {
for  $bookmark (@matches) {
$bookmark =~ tr/\x0d\n\\\+//d;
if (length($bookmark) > 0) { push(@lines,join("",$first,"\"",$bookmark,"\" 1 \"",$file,"\" \"",$bookmark,"\" ",$mid, 5+length($file)," \" --> ",$file,$last, "\n")); }}}
}
} ;
@slines = sort (@lines);
for  $sline (@slines) { print INDEX $sline ;} 
print INDEX "\}\{MARK \"2 0 1\" 0 \}\{VIEWOPTS 1 1 0 1 1 1803 \}\n"; 

 

